#include <yandex/maps/wiki/diffalert/runner.h>

#include "run_utils.h"

#include <maps/libs/common/include/exception.h>

#include <exception>

namespace maps {
namespace wiki {
namespace diffalert {

namespace {

typedef std::function<void(const DiffContext&, MessageReporter&)> Check;

const std::vector<Check> EDITOR_SPECIFIC_CHECKS {
    checkAdChangesEditor,
    checkMajorFeaturesEditor,
    checkImportantRdEditor,
    checkRdElUnderConstructionEditor,
    checkRdElPoorConditionHighFc,
    checkRdAssociationEditor,

    checkCategoryChangeModeration,
    checkLocationChangeModeration,

    checkMajorPoiModeration,
    checkPoiAssignModeration,
    checkPoiNamesModeration,
};

} // namespace


std::set<Message> runEditorChecks(const DiffContext& d)
{
    MessageReporter reporter(d.objectId());
    try {
        runCommonChecks(d, reporter);
        run(d, reporter, EDITOR_SPECIFIC_CHECKS);
    } catch (const maps::Exception& ex) {
        throw RuntimeError()
            << "Catch maps::exception, while check object " << d.objectId();
    } catch (const std::exception& ex) {
        throw RuntimeError()
            << "Catch '" << ex.what() << "', while check object " << d.objectId();
    }
    return std::move(reporter.messages);
}

} // namespace diffalert
} // namespace wiki
} // namespace maps
