#pragma once

#include <string>

namespace maps {
namespace wiki {
namespace diffalert {

namespace columns {

const std::string ATTRIBUTES_ID = "attributes_id";
const std::string CATEGORY_ID = "category_id";
const std::string THE_GEOM = "the_geom";
const std::string COUNT = "count";
const std::string DESCRIPTION = "description";
const std::string ID = "id";
const std::string MAJOR_PRIORITY = "pri_major";
const std::string MINOR_PRIORITY = "pri_minor";
const std::string SORT_PRIORITY = "pri_sort";
const std::string OBJECT_ID = "object_id";
const std::string TASK_ID = "task_id";
const std::string INSPECTED_BY = "inspected_by";
const std::string INSPECTED_AT = "inspected_at";
const std::string INSPECTED_COUNT = "inspected_count";
const std::string TOTAL_COUNT = "total_count";
const std::string REGION_PRIORITY = "pri_region";
const std::string OBJECT_LABEL = "object_label";
const std::string HAS_OWN_NAME = "has_own_name";
const std::string POSTPONED = "postponed";

const std::string MESSAGE_COLUMNS =
    columns::ID + ',' +
    columns::TASK_ID + ',' +
    columns::OBJECT_ID + ',' +
    columns::MAJOR_PRIORITY + ',' +
    columns::MINOR_PRIORITY + ',' +
    columns::SORT_PRIORITY + ',' +
    columns::CATEGORY_ID + ',' +
    columns::DESCRIPTION + ',' +
    "ST_AsBinary(" + columns::THE_GEOM + ") as " + columns::THE_GEOM + ',' +
    columns::INSPECTED_BY + ',' +
    columns::INSPECTED_AT + ',' +
    columns::OBJECT_LABEL + ',' +
    columns::HAS_OWN_NAME + ',' +
    columns::POSTPONED;

} // namespace columns

namespace funcs {
const std::string GET_ATTRIBUTES_ID = "diffalert.insert_message_attributes";
} // namespace funcs

namespace tables {
const std::string MESSAGES = "diffalert.messages";
const std::string MESSAGE_ATTRIBUTES = "diffalert.message_attributes";
} // namespace tables

namespace join {
const std::string WITH_ATTRIBUTES =
    " LEFT JOIN diffalert.message_attributes"
        " USING (" + columns::ATTRIBUTES_ID + ')';
} // namespace join

const size_t MERCATOR_SRID = 3395;

} // namespace diffalert
} // namespace wiki
} // namespace maps
