#include <maps/wikimap/mapspro/libs/editor_client/include/basic_object.h>

#include <maps/libs/geolib/include/conversion.h>

namespace maps::wiki::editor_client {

std::optional<geolib3::SimpleGeometryVariant> BasicEditorObject::getGeometryInMercator() const
{
    std::optional<geolib3::SimpleGeometryVariant> retVal;
    if (geoGeometry_) {
        retVal = geolib3::convertGeodeticToMercator(geoGeometry_.value());
    }
    return retVal;
}

std::optional<geolib3::SimpleGeometryVariant> BasicEditorObject::getGeometryInGeodetic() const
{
    return geoGeometry_;
}

void BasicEditorObject::setGeometryInMercator(geolib3::SimpleGeometryVariant mercGeometry)
{
    geoGeometry_ = geolib3::convertMercatorToGeodetic(mercGeometry);
}

void BasicEditorObject::setGeometryInGeodetic(geolib3::SimpleGeometryVariant geoGeometry)
{
    geoGeometry_ = std::move(geoGeometry);
}

} // namespace maps::wiki::editor_client
