#pragma once

#include <maps/libs/chrono/include/time_point.h>
#include <yandex/maps/wiki/revision/common.h>
#include <yandex/maps/wiki/revision/revisionid.h>
#include <maps/libs/geolib/include/variant.h>
#include <optional>

#include <string>
#include <vector>
#include <map>

namespace maps::wiki::editor_client {

struct ObjectIdentity
{
    revision::DBID id = 0;
    std::optional<revision::RevisionID> revisionId;
    std::string categoryId;
};

struct BasicCommitData
{
    revision::DBID id = 0;
    chrono::TimePoint date;
    revision::UserID author = 0;
};

struct BasicEditorObject : public ObjectIdentity
{
    std::optional<BasicCommitData> recentCommit;
    std::optional<BasicCommitData> firstCommit;

    std::unordered_map<std::string, std::string> plainAttributes;
    std::unordered_map<std::string, std::vector<std::unordered_map<std::string, std::string>>> tableAttributes;
    std::unordered_map<std::string, std::vector<std::string>> multiValueAttributes;
    bool deleted = false;

    std::optional<geolib3::SimpleGeometryVariant> getGeometryInMercator() const;
    std::optional<geolib3::SimpleGeometryVariant> getGeometryInGeodetic() const;

    void setGeometryInMercator(geolib3::SimpleGeometryVariant mercGeometry);
    void setGeometryInGeodetic(geolib3::SimpleGeometryVariant geoGeometry);

private:
    std::optional<geolib3::SimpleGeometryVariant> geoGeometry_;
};

} // namespace maps::wiki::editor_client
