#pragma once
#include <maps/libs/common/include/exception.h>

namespace maps::wiki::editor_client {

class ServerException : public maps::Exception
{
public:
    explicit ServerException(std::string status, std::string serverResponse)
        : status_(status)
        , serverResponse_(std::move(serverResponse))
    {
        attrs().emplace("status", std::move(status));
    }

    const std::string& status() const { return status_; }
    const std::string& serverResponse() const { return serverResponse_; }

private:
    std::string status_;
    std::string serverResponse_;

};

} // maps::wiki::editor_client
