#pragma once
#include <maps/wikimap/mapspro/libs/editor_client/include/basic_object.h>
#include <maps/wikimap/mapspro/libs/editor_client/include/poi_conflicts.h>

#include <maps/libs/http/include/http.h>
#include <maps/libs/geolib/include/fwd.h>
#include <maps/libs/enum_io/include/enum_io_fwd.h>

namespace maps::wiki::editor_client {

enum class GeomPredicate
{
    CoveredBy,
    Intersects
};

enum class IsGeoproduct
{
    True,
    False
};

DECLARE_ENUM_IO(IsGeoproduct);

struct DiffAlertMessage
{
    uint32_t priority; // lower values higher priority
    std::string message; // message key to tanker keyset nmaps/task-alerts
};

class Instance
{
public:
    explicit Instance(std::string urlBase, revision::UserID uid);

    BasicEditorObject getObjectById(revision::DBID objectId) const;

    BasicEditorObject saveObject(
        const BasicEditorObject& object,
        std::vector<DiffAlertMessage> messages = {});

    void deleteObject(revision::DBID objectId);

    std::vector<ObjectIdentity> getObjectsByLasso(
        const std::set<std::string>& categories,
        const geolib3::SimpleGeometryVariant& mercGeometry,
        std::optional<double> threshold,
        size_t limit,
        GeomPredicate geomPredicate) const;

    std::vector<ObjectIdentity> getObjectsByBusinessId(
        const std::string& businessId,
        std::optional<const geolib3::Point2> mercPointHint,
        std::optional<double> mercDistance) const;

    std::vector<BasicCommitData> getHistory(revision::DBID objectId, size_t page, size_t perPage) const;


    PoiConflicts getPoiConflicts(
        std::optional<revision::DBID> selfObjectId,
        std::optional<revision::DBID> indoorLevelObjectId,
        const geolib3::Point2& mercPointHint,
        const IsGeoproduct isGeoproduct) const;


private:
    const std::string urlBase_;
    const revision::UserID uid_;
    mutable http::Client client_;
    std::string token_;

};

} // namespace maps::wiki::editor_client
