#pragma once

#include <string>

namespace maps {
namespace wiki {
namespace filters {

const std::string FILTER_TABLE = "filters.filter";

const std::string FILTER_ID_COLUMN = "filter_id";

const std::string CREATED_AT_COLUMN = "created_at";
const std::string CREATED_BY_COLUMN = "created_by";
const std::string IS_DELETED_COLUMN = "is_deleted";

const std::string NAME_COLUMN = "name";
const std::string IS_PUBLIC_COLUMN = "is_public";

const std::string EXPRESSION_ID_COLUMN = "expression_id";


const std::string FILTER_EXPRESSION_TABLE = "filters.filter_expression";
const std::string JOIN_FILTER_EXPRESSION_TABLE =
    " JOIN " + FILTER_EXPRESSION_TABLE + " USING(" + EXPRESSION_ID_COLUMN + ")";

const std::string EXPRESSION_CREATED_AT_COLUMN = "expression_created_at";
const std::string EXPRESSION_CREATED_BY_COLUMN = "expression_created_by";
const std::string LANG_VERSION_COLUMN = "lang_version";
const std::string EXPRESSION_COLUMN = "expression";

const std::string FILTER_META_COLUMNS =
    FILTER_ID_COLUMN
    + "," + CREATED_AT_COLUMN + "," + CREATED_BY_COLUMN
    + "," + IS_DELETED_COLUMN
    + "," + NAME_COLUMN + "," + IS_PUBLIC_COLUMN;

const std::string STORED_EXPRESSION_COLUMNS =
    EXPRESSION_ID_COLUMN
    + "," + EXPRESSION_CREATED_AT_COLUMN + "," + EXPRESSION_CREATED_BY_COLUMN
    + "," + LANG_VERSION_COLUMN + "," + EXPRESSION_COLUMN;

const std::string STORED_FILTER_COLUMNS =
    FILTER_META_COLUMNS + "," + STORED_EXPRESSION_COLUMNS;

} // namespace filters
} // namespace wiki
} // namespace maps
