#pragma once

#include <yandex/maps/wiki/filters/common.h>

#include <yandex/maps/wiki/revision/filters.h>

#include <pqxx/pqxx>

#include <string>
#include <memory>

namespace maps {
namespace wiki {
namespace filters {

class ParsedExpression
{
public:
    ~ParsedExpression();

    ParsedExpression(ParsedExpression&& other) noexcept;
    ParsedExpression& operator=(ParsedExpression&& other) noexcept;

    std::string viewFilterClause(pqxx::transaction_base& txn, const std::string& viewAlias = {}) const;
    std::optional<revision::filters::ProxyFilterExpr> revisionFilter() const;

    static ParsedExpression parse(const std::string& text);

private:
    class Impl;
    explicit ParsedExpression(Impl*);

private:
    std::unique_ptr<Impl> impl_;
};

} // namespace filters
} // namespace wiki
} // namespace maps
