#pragma once

#include <yandex/maps/wiki/filters/common.h>
#include <yandex/maps/wiki/filters/parsed_expression.h>

#include <pqxx/pqxx>

#include <string>

namespace maps {
namespace wiki {
namespace filters {

class StoredExpression
{
public:
    ~StoredExpression();

    TExpressionId id() const;
    const std::string& createdAt() const;
    TUId createdBy() const;

    const std::string& text() const;
    const std::string& langVersion() const;

    ParsedExpression parsed() const;

    static StoredExpression create(
            pqxx::transaction_base& txn, TUId uid, const std::string& text);
    static StoredExpression load(pqxx::transaction_base& txn, TExpressionId id);

private:
    StoredExpression(const pqxx::row& row);

    friend class StoredFilter;

    TExpressionId id_;
    std::string createdAt_;
    TUId createdBy_;

    std::string text_;
    std::string langVersion_;

};

} // namespace filters
} // namespace wiki
} // namespace maps
