#include <yandex/maps/wiki/filters/parsed_expression.h>

#include "parser.h"

#include <yandex/maps/wiki/filters/exception.h>

namespace maps {
namespace wiki {
namespace filters {

namespace rf = revision::filters;

class ParsedExpression::Impl
{
public:
    Impl(NodePtr root_) : root(std::move(root_)) { }

    NodePtr root;
};

ParsedExpression::ParsedExpression(Impl* impl) : impl_(impl) { }

ParsedExpression::ParsedExpression(ParsedExpression&& other) noexcept
    : impl_(std::move(other.impl_))
{}

ParsedExpression& ParsedExpression::operator=(ParsedExpression&& other) noexcept
{
    if (&other != this) {
        impl_.swap(other.impl_);
    }
    return *this;
}

ParsedExpression::~ParsedExpression() { }

std::string ParsedExpression::viewFilterClause(pqxx::transaction_base& txn, const std::string& viewAlias) const
{ return impl_->root->viewFilterClause(txn, viewAlias); }

std::optional<rf::ProxyFilterExpr>
ParsedExpression::revisionFilter() const
{
    if (impl_->root->hasServiceAttrsClause()) {
        return std::nullopt;
    }
    return impl_->root->revisionFilter();
}

ParsedExpression ParsedExpression::parse(const std::string& text)
{
    Parser parser(text);
    return ParsedExpression(new ParsedExpression::Impl(parser.parse()));
}

} // namespace filters
} // namespace wiki
} // namespace maps
