#pragma once

#include <list>
#include <cstddef>
#include <cstring>
#include <ostream>
#include <string>

namespace maps {
namespace wiki {
namespace filters {

class Token
{
public:
    enum class Type
    {
        Identifier,
        IntLiteral,
        StringLiteral,
        Punctuation,
        Operator,
        End,
    };

    Token(const char* start, const char* end, size_t startPos, Type type)
        : start_(start), end_(end), startPos_(startPos), type_(type)
    {}


    Type type() const { return type_; }

    size_t startPos() const { return startPos_; }

    size_t length() const { return static_cast<size_t>(end_ - start_); }

    std::string str() const { return std::string(start_, end_); }

    bool equals(const std::string& str) const
    {
        return str.length() == length()
            && std::memcmp(str.data(), start_, str.length()) == 0;
    }

private:
    const char* start_;
    const char* end_;
    size_t startPos_;
    Type type_;
};

std::ostream& operator<<(std::ostream& os, Token::Type token);

std::list<Token> tokenize(const std::string& str);

} // namespace filters
} // namespace wiki
} // namespace maps
