#pragma once

#include <string>
#include <vector>

namespace maps::wiki::flat_range {

const std::string BOUNDS_DELIMITER = "?";

static inline void ltrim(std::string &s) {
    s.erase(s.begin(), std::find_if(s.begin(), s.end(), [](unsigned char ch) {
        return !std::isspace(ch);
    }));
}

static inline void rtrim(std::string &s) {
    s.erase(std::find_if(s.rbegin(), s.rend(), [](unsigned char ch) {
        return !std::isspace(ch);
    }).base(), s.end());
}

static inline void trim(std::string &s) {
    ltrim(s);
    rtrim(s);
}

static inline std::string ltrim_copy(std::string s) {
    ltrim(s);
    return s;
}

static inline std::string rtrim_copy(std::string s) {
    rtrim(s);
    return s;
}

static inline std::string trim_copy(std::string s) {
    trim(s);
    return s;
}

bool isNumber(const std::string& text);
bool isQuoted(const std::string& text);

void replaceMinusWithBoundsDelimiterKeepNegative(std::string &s);
size_t commonNotNumberSuffixLen(const std::string& s1, const std::string& s2);
size_t commonNotNumberPrefixLen(const std::string& s1, const std::string& s2);

std::vector<std::string> splitQuoted(const std::string& input);

} // namespace maps::wiki::flat_range
