#pragma once

#include <maps/wikimap/mapspro/libs/flat_range/include/common.h>
#include <maps/wikimap/mapspro/libs/flat_range/include/range.h>
#include <maps/libs/introspection/include/comparison.h>

#include <string>
#include <tuple>
#include <vector>

namespace maps::wiki::flat_range {

struct LevelWithFlats
{
    std::string levelName;
    Ranges flatRanges;

    auto introspect() const
    { return std::tie(levelName, flatRanges); }
};

using introspection::operator==;

struct DistributionResult
{
    std::vector<LevelWithFlats> levelsWithFlats;
    bool isComplete = true;
};

inline bool
operator==(
    const maps::wiki::flat_range::DistributionResult& lhs,
    const maps::wiki::flat_range::DistributionResult& rhs)
{
    return
        lhs.levelsWithFlats == rhs.levelsWithFlats &&
        lhs.isComplete == rhs.isComplete;
}

DistributionResult
distributeFlatsByLevels(const std::vector<FlatLevelRange>& flatLevelRanges);

} // namespace maps::wiki::flat_range
