#pragma once

#include <maps/libs/introspection/include/comparison.h>
#include <maps/libs/common/include/exception.h>

#include <optional>
#include <string>
#include <tuple>
#include <vector>

namespace maps::wiki::flat_range {

class ParseException : public maps::Exception
{
};

class Range
{
public:
    Range(const std::string& singleValue);
    Range(const std::string& start, const std::string& end);

    size_t size() const;

    std::string value(size_t n) const;
    std::string first() const { return value(0); }
    std::string last() const { return value(size() - 1); }
    std::string min() const;
    std::string max() const;

    bool named() const { return !constPart_.empty(); }

    auto introspect() const
    { return std::tie(start_, end_, constPart_, numberFirst_); }

private:
    std::optional<int> start_;
    std::optional<int> end_;
    std::string constPart_;
    bool numberFirst_ = false;
};

using introspection::operator==;

using Ranges = std::vector<Range>;
Ranges parse(const std::string& text);

} // namespace maps::wiki::flat_range
