#pragma once

#include <maps/wikimap/mapspro/libs/flat_range/include/common.h>
#include <maps/wikimap/mapspro/libs/flat_range/include/range.h>
#include <maps/libs/enum_io/include/enum_io_fwd.h>

#include <set>

namespace maps::wiki::flat_range {

const int MAX_FLATS_PER_ENTRANCE = 2000;

enum class ValidationResult {
    BadFlatRange = 0,
    BadLevelRange = 1,
    FlatRangesIntersection = 2,
    FlatsOutOfRange = 3,
    LevelsOutOfRange = 4,
    TooManyFlatsPerEntrance = 5,
    FlatsReverseOrder = 6,
    LevelsReverseOrder = 7,
};

DECLARE_ENUM_IO(ValidationResult);

std::set<ValidationResult>
validate(const std::vector<FlatLevelRange>& flatLevelRanges);

} // namespace maps::wiki::flat_range
