#pragma once

#include <maps/wikimap/mapspro/libs/types/include/uid.h>

namespace maps::wiki::gdpr {

using types::TUid;

class User
{
public:
    explicit User(TUid uid) : uid_(uid) {}

    bool hidden() const
    { return uid_ <= 0; }

    TUid uid() const
    { return hidden() ? 0 : uid_; }

    TUid realUid() const
    { return hidden() ? -uid_ : uid_; }

private:
    TUid uid_;
};

} // namespace maps::wiki::gdpr
