#pragma once

#include <maps/libs/geolib/include/line.h>
#include <maps/libs/geolib/include/vector.h>
#include <maps/libs/geolib/include/bounding_box.h>

namespace maps {
namespace wiki {
namespace geom_tools {

enum class Direction { X, Y };

enum class Relation { Less, Less_Touches, Equal, Greater, Greater_Touches, Intersects };

class CutLine {
public:
    CutLine(Direction direction, double coord, double tolerance)
        : direction_(direction)
        , coord_(coord)
        , tolerance_(tolerance)
        , line_(
            direction_ == Direction::X ? geolib3::Point2(coord_, 0) : geolib3::Point2(0, coord_),
            direction_ == Direction::X ? geolib3::Vector2(0, 1) : geolib3::Vector2(1, 0))
    {}

    Direction direction() const { return direction_; }
    double coord() const { return coord_; }
    double tolerance() const { return tolerance_; }

    const geolib3::Line2& line() const { return line_; }

    double pointCoord(const geolib3::Point2& point) const;

    template <class Geom>
    Relation relation(const Geom& geom) const;

private:
    Direction direction_;
    double coord_;
    double tolerance_;

    geolib3::Line2 line_;
};

} // namespace geom_tools
} // namespace wiki
} // namespace maps
