#pragma once

#include <yandex/maps/wiki/common/geom.h>

#include <maps/libs/geolib/include/linear_ring.h>
#include <maps/libs/geolib/include/polygon.h>

#include <geos/geom/Geometry.h>

#include <vector>

namespace maps {
namespace wiki {
namespace geom_tools {

typedef common::Geom WikiGeom;
typedef const WikiGeom* ConstWikiGeomPtr;
typedef std::vector<ConstWikiGeomPtr> WikiGeomPtrVector;

typedef geos::geom::Geometry GeosGeometry;
typedef const geos::geom::Geometry* ConstGeosGeometryPtr;
typedef std::vector<ConstGeosGeometryPtr> GeosGeometryPtrVector;

typedef std::vector<geolib3::LinearRing2> GeolibLinearRingVector;
typedef std::vector<geolib3::Polygon2> GeolibPolygonVector;

enum class ValidateResult { No, Yes };

} // namespace geom_tools
} // namespace wiki
} // namespace maps
