#pragma once

#include "common.h"

#include <maps/libs/geolib/include/bounding_box.h>
#include <maps/libs/geolib/include/multipolygon.h>
#include <maps/libs/geolib/include/point.h>

#include <geos/geom/Envelope.h>

namespace maps {
namespace wiki {
namespace geom_tools {

template <class GeomTypeFrom, class GeomTypeTo>
GeomTypeTo convert(const GeomTypeFrom& geom);

double correctGeoDistanceToMerc(
    double geoDistance,
    const geolib3::Point2& pointMerc);

double correctMercDistanceToGeo(
    double mercDistance,
    const geolib3::Point2& pointMerc);

geolib3::BoundingBox makeVicinityBboxMerc(
    const geolib3::Point2& centerMerc,
    double halfDistGeo);

} // namespace geom_tools
} // namespace wiki
} // namespace maps
