#pragma once

#include <yandex/maps/wiki/geom_tools/common.h>

#include <maps/libs/geolib/include/polyline.h>
#include <maps/libs/common/include/exception.h>

namespace maps {
namespace wiki {
namespace geom_tools {

class RingBuildError : public maps::RuntimeError {};

class LinearRingBuilder {
public:
    static geolib3::LinearRing2 build(
        const WikiGeomPtrVector& linestrings,
        double tolerance);
    static geolib3::LinearRing2 build(
        const GeosGeometryPtrVector& linestrings,
        double tolerance);
    static geolib3::LinearRing2 build(
        const geolib3::PolylinesVector& linestrings,
        double tolerance);
};

class PolygonBuildError : public maps::RuntimeError {};

class PolygonBuilder {
public:
    static GeolibPolygonVector build(
        const WikiGeomPtrVector& shells,
        const WikiGeomPtrVector& holes,
        ValidateResult validateResult);

    static GeolibPolygonVector build(
        const GeosGeometryPtrVector& shells,
        const GeosGeometryPtrVector& holes,
        ValidateResult validateResult);

    static GeolibPolygonVector build(
        const GeolibLinearRingVector& shells,
        const GeolibLinearRingVector& holes,
        ValidateResult validateResult);
};

} // namespace geom_tools
} // namespace wiki
} // namespace maps
