#pragma once

#include <yandex/maps/wiki/geom_tools/common.h>

#include <maps/libs/common/include/exception.h>

namespace maps {
namespace wiki {
namespace geom_tools {

class PolygonPartitionException : public maps::Exception {};

enum class PartitionStrategy { AdaptiveRectangularGrid };

/**
 * throws PolygonPartitionException in case of error
 */
GeolibPolygonVector
partition(
    const GeolibPolygonVector& polygons,
    size_t maxVertices,
    double minSize,
    double tolerance,
    PartitionStrategy strategy = PartitionStrategy::AdaptiveRectangularGrid);

} // namespace geom_tools
} // namespace wiki
} // namespace maps
