#pragma once

#include <yandex/maps/wiki/graph/common.h>

#include <vector>

namespace maps::wiki::graph {

class Edge {

public:
    Edge(NodeID startNodeId, NodeID endNodeId, double weight = 1)
        : startNodeId_(startNodeId)
        , endNodeId_(endNodeId)
        , weight_(weight)
    {}

    NodeID startNodeId() const { return startNodeId_; }
    NodeID endNodeId() const { return endNodeId_; }
    double weight() const { return weight_; }

private:
    NodeID startNodeId_;
    NodeID endNodeId_;
    double weight_;
};

typedef std::vector<Edge> Edges;

} // namespace maps::wiki::graph
