#pragma once

#include <yandex/maps/wiki/graph/common.h>
#include <yandex/maps/wiki/graph/graph.h>

namespace maps::wiki::graph {

class ShortestPath {

public:
    ShortestPath(Path path, double length)
        : path_(std::move(path))
        , length_(length)
    {}

    const Path& path() const { return path_; }
    double length() const { return length_; }

private:
    Path path_;
    double length_;
};

ShortestPath findShortestPath(GetOutEdges outEdges, NodeID fromNodeId, NodeID toNodeId);
ShortestPath findShortestPath(GetOutEdges outEdges, NodeID fromNodeId, NodePredicate isFinishNode);

} // namespace maps::wiki::graph
