#pragma once

#include <yandex/maps/wiki/graph/common.h>
#include <yandex/maps/wiki/graph/graph.h>

#include <unordered_map>

namespace maps::wiki::graph {

using StronglyConnectedComponents = std::vector<NodeIds>;

// See also: http://en.wikipedia.org/wiki/Tarjan%27s_strongly_connected_components_algorithm
class StronglyConnectedComponentsFinder
{
public:
    StronglyConnectedComponentsFinder();
    ~StronglyConnectedComponentsFinder();

    const StronglyConnectedComponents& stronglyConnectedComponents() const
    {
        return components_;
    }

    size_t componentIndex(NodeID nodeId) const;

    void exploreNode(NodeID fromNodeId, GetOutEdges outEdges);

private:
    struct NodeInfo;

    StronglyConnectedComponents components_;
    std::unordered_map<NodeID, size_t> nodeIdToComponent_;
    std::unordered_map<NodeID, NodeInfo> nodeIdToNodeInfo_;
};

} // namespace maps::wiki::graph
