#include "update_attrs_impl.h"
#include <yandex/maps/wiki/groupedit/object.h>
#include <yandex/maps/wiki/groupedit/session.h>

#include <maps/libs/common/include/exception.h>

namespace maps {
namespace wiki {
namespace groupedit {
namespace actions {

namespace {

const std::string GROUP_MOD_ATTRS_ACTION = "group-modified-attributes";

const std::string ATTR_VALUES_DELIM = "|";

} // namespace

UpdateAttrsAction::UpdateAttrsAction()
    : impl_(new Impl)
{ }

UpdateAttrsAction::~UpdateAttrsAction() = default;

void UpdateAttrsAction::addAttributeValue(std::string name, std::string value)
{
    REQUIRE(!impl_->attributesToRemove.count(name),
        "Adding attribute " << name << " value"
        ", but it is marked for removal");

    auto existingIt = impl_->newAttributeValues.find(name);
    if (existingIt == std::end(impl_->newAttributeValues)) {
        impl_->newAttributeValues.insert(
            {std::move(name), std::move(value)});
    } else {
        existingIt->second += ATTR_VALUES_DELIM;
        existingIt->second += value;
    }
}

void UpdateAttrsAction::removeAttribute(std::string name)
{
    REQUIRE(!impl_->newAttributeValues.count(name),
        "Removing attribute " << name << ", but it is marked for update");

    impl_->attributesToRemove.insert(std::move(name));
}

std::vector<TCommitId> UpdateAttrsAction::perform(
        const Session& session,
        const RevGeomFilter& revGeomFilter,
        TUserId author)
{
    return session.query(revGeomFilter).update(
        GROUP_MOD_ATTRS_ACTION,
        author,
        [&](Object& obj) {
            for (const auto& attrValuePair : impl_->newAttributeValues) {
                obj.setAttribute(
                    attrValuePair.first, attrValuePair.second);
            }
            for (const auto& attr : impl_->attributesToRemove) {
                obj.removeAttribute(attr);
            }
        });
}

} // namespace actions
} // namespace groupedit
} // namespace wiki
} // namespace maps
