#pragma once

#include <yandex/maps/wiki/groupedit/common.h>
#include "object_diff.h"

#include <yandex/maps/wiki/threadutils/threadedqueue.hpp>

#include <list>
#include <thread>
#include <vector>

namespace maps {
namespace wiki {

namespace revision {

class RevisionsGateway;

}

namespace groupedit {

class ObjectDiff;

class CommitWriter
{
public:
    void add(ObjectDiff diff);

    std::vector<TCommitId> write(
        revision::RevisionsGateway& gateway,
        TUserId author,
        std::string commitAction,
        size_t maxCommitSize);

private:
    ThreadedQueue<ObjectDiff> diffQueue_;
};

} // namespace groupedit
} // namespace wiki
} // namespace maps
