#pragma once

#include <yandex/maps/wiki/groupedit/common.h>

#include <maps/libs/geolib/include/bounding_box.h>
#include <maps/libs/geolib/include/polygon.h>
#include <maps/libs/geolib/include/polyline.h>

#include <optional>
#include <string>

namespace maps {
namespace wiki {
namespace groupedit {

class GeometryFilter
{
public:
    GeometryFilter();
    GeometryFilter(GeomPredicate predicate, std::string wkb);

    GeomPredicate predicate() const;
    const std::string& wkb() const;
    std::optional<geolib3::BoundingBox> boundingBox() const;

    bool apply(const std::optional<std::string>& optionalWkb) const;

private:
    GeomPredicate predicate_;
    std::string wkb_;
    std::optional<geolib3::Polygon2> polygonGeom_;
    std::optional<geolib3::Polyline2> polylineGeom_;
};

} // namespace groupedit
} // namespace wiki
} // namespace maps
