#pragma once

#include <yandex/maps/wiki/groupedit/common.h>

#include <memory>
#include <vector>

namespace maps {
namespace wiki {
namespace groupedit {

class RevGeomFilter;
class Session;

namespace actions {

class UpdateAttrsAction
{
public:
    UpdateAttrsAction();
    ~UpdateAttrsAction();

    void addAttributeValue(std::string name, std::string value);
    void removeAttribute(std::string name);

    std::vector<TCommitId> perform(
        const Session& session,
        const RevGeomFilter& revGeomFilter,
        TUserId author);

private:
    class Impl;
    std::unique_ptr<Impl> impl_;
};

} // namespace actions
} // namespace groupedit
} // namespace wiki
} // namespace maps
