#pragma once

#include <yandex/maps/wiki/groupedit/common.h>
#include <yandex/maps/wiki/groupedit/relation.h>
#include <yandex/maps/wiki/revision/revisionid.h>

#include <list>
#include <memory>
#include <optional>
#include <utility>
#include <unordered_set>

namespace maps {
namespace wiki {
namespace groupedit {

class ObjectDiff;

template<typename Iterator>
class IteratorRange
{
public:
    IteratorRange(Iterator begin, Iterator end) : begin_(begin), end_(end) { }

    Iterator begin() const { return begin_; }
    Iterator end() const { return end_; }

private:
    Iterator begin_;
    Iterator end_;
};

class Object
{
public:
    Object(
        revision::RevisionID revisionId,
        revision::ObjectData objectData,
        std::list<Relation> relations);

    TObjectId id() const { return revisionId_.objectId(); }
    revision::RevisionID revisionId() const { return revisionId_; }

    const TCategoryId& category() const { return category_; }
    void changeCategory(const TCategoryId& category);

    std::optional<std::string> geometryWkb() const;
    void setGeometryWkb(std::string wkb);

    std::optional<std::string> attribute(const std::string& name) const;
    void setAttribute(const std::string& name, std::string value);
    void removeAttribute(const std::string& name);
    Attributes attributes() const;

    typedef IteratorRange<std::list<Relation>::iterator> RelationsRange;
    typedef IteratorRange<std::list<Relation>::const_iterator> ConstRelationsRange;

    RelationsRange relations();
    ConstRelationsRange relations() const;

    void addRelationToMaster(
            TObjectId otherId, TCategoryId otherCategory, std::string role);
    void addRelationToSlave(
            TObjectId otherId, TCategoryId otherCategory, std::string role);

    void setDeleted();

    bool hasChanges() const;
private:
    friend class ObjectDiff;

    std::optional<revision::Attributes> newAttributesImpl() const;

    void setAttributeImpl(const std::string& name, std::string&& value);
    void removeAttributeImpl(const std::string& name);

    revision::RevisionID revisionId_;
    revision::ObjectData data_;
    TCategoryId category_;
    std::list<Relation> relations_;

    std::optional<std::string> newGeometryWkb_;
    revision::Attributes attributesDiff_;
    std::unordered_set<std::string> removedAttributeNames_;
    bool isDeleted_;
};

} // namespace groupedit
} // namespace wiki
} // namespace maps
