#pragma once

#include <yandex/maps/wiki/groupedit/common.h>

#include <memory>

namespace maps {
namespace wiki {
namespace groupedit {

class ObjectDiff;
struct RelationData;

class Relation
{
public:
    Relation(
        TObjectId boundObjectId,
        std::shared_ptr<RelationData> relationData);

    enum class Type { Master, Slave };
    Type type() const { return type_; }

    const std::string& role() const;
    TObjectId otherId() const;
    const TCategoryId& otherCategory() const;

    bool isDeleted() const;
    void setDeleted();

private:
    friend class ObjectDiff;

    TObjectId boundObjectId_;
    Type type_;
    std::shared_ptr<RelationData> relationDataPtr_;
};

} // namespace groupedit
} // namespace wiki
} // namespace maps
