#pragma once

#include <yandex/maps/wiki/groupedit/common.h>
#include <yandex/maps/wiki/revision/branch.h>
#include <yandex/maps/wiki/revision/range.h>
#include <yandex/maps/wiki/revision/revisionsgateway.h>

#include <maps/wikimap/mapspro/libs/groupedit/geometry_filter.h>

#include <pqxx/pqxx>

#include <memory>
#include <string>
#include <functional>

namespace maps {
namespace wiki {

namespace revision {
namespace filters {

class ProxyFilterExpr;

} // namespace filters
} // namespace revision

namespace groupedit {

class Object;
typedef std::function<void(Object&)> ObjectVisitor;
typedef std::function<void(const Object&)> ConstObjectVisitor;

typedef pqxx::transaction_base Transaction;

class Query;
class Session;

class RevGeomFilter
{
public:
    explicit RevGeomFilter(revision::filters::ProxyFilterExpr revFilter);
    RevGeomFilter(GeomPredicate geomPredicate, std::string wkb);
    RevGeomFilter(
        revision::filters::ProxyFilterExpr revFilter,
        GeomPredicate geomPredicate,
        std::string wkb);

    const revision::filters::ProxyFilterExpr& revFilter() const { return filterExpr_; }
    GeomPredicate geomPredicate() const;
    const std::string& wkb() const;

private:
    void init();

    friend class Session;

    revision::filters::ProxyFilterExpr filterExpr_;
    GeometryFilter geomFilter_;
};

class Session
{
public:
    Session(Transaction& txn, TBranchId branchId);

    // Constructs a readonly session (i.e. calling query().update()
    // produces runtime error.
    Session(Transaction& txn, TBranchId branchId, TCommitId headCommitId);

    Query query(RevGeomFilter revGeomFilter) const;
    Query query(const revision::filters::ProxyFilterExpr& filterExpr) const;
    Query query(
            const revision::filters::ProxyFilterExpr& filterExpr,
            GeomPredicate geomPredicate,
            const std::string& wkb) const;

    Query query(const revision::ConstRange<TObjectId>& oids) const;

private:
    Transaction& txn_;
    revision::Branch branch_;
    bool readonly_;
    revision::DBID headCommitId_;
};

class Query
{
public:
    Query() = default;
    Query(
        bool readonly,
        std::unique_ptr<revision::RevisionsGateway> gateway,
        revision::DBID commitId,
        std::vector<revision::RevisionID> revisionIds,
        const GeometryFilter& geomFilter);

    std::vector<TCommitId> update(
        std::string commitAction,
        TUserId author,
        const ObjectVisitor& visitor) const;

    void visit(const ConstObjectVisitor& visitor) const;

    bool readonly_;
    std::unique_ptr<revision::RevisionsGateway> gateway_;
    revision::DBID commitId_;
    std::vector<revision::RevisionID> revisionIds_;
    GeometryFilter geomFilter_;
};

} // namespace groupedit
} // namespace wiki
} // namespace maps
