#include "object_diff.h"
#include "relation_data.h"

#include <yandex/maps/wiki/groupedit/object.h>
#include <maps/libs/common/include/exception.h>

namespace maps {
namespace wiki {
namespace groupedit {

ObjectDiff::ObjectDiff(Object obj)
{
    TObjectId objId = obj.id();

    NewRevisionData newData{obj.revisionId_, {}};

    if (obj.isDeleted_) {
        newData.second.deleted = true;
    } else {
        newData.second.geometry = std::move(obj.newGeometryWkb_);
        newData.second.attributes = obj.newAttributesImpl();
    }

    if (newData.second.deleted
            || newData.second.geometry
            || newData.second.attributes) {
        newRevisionsData_.push_back(std::move(newData));
    }

    for (Relation& rel : obj.relations_) {
        ASSERT(rel.relationDataPtr_);
        const auto& relData = *rel.relationDataPtr_;
        if (relData.deletedFrom == objId && !relData.revisionId.empty()) {
            NewRevisionData newRevData{relData.revisionId, {}};
            newRevData.second.deleted = true;
            newRevisionsData_.push_back(std::move(newRevData));
        } else if (!relData.deletedFrom && relData.revisionId.empty()) {
            revision::ObjectData objData(
                    revision::Attributes{ {REL_ROLE_ATTR, relData.role},
                                          {REL_MASTER_ATTR, relData.masterCategory},
                                          {REL_SLAVE_ATTR, relData.slaveCategory} });
            objData.relationData =
                revision::RelationData(relData.masterId, relData.slaveId);
            newRevisionsData_.emplace_back(relData.revisionId, objData);
        }
    }
}

size_t ObjectDiff::revisionsCount() const
{ return newRevisionsData_.size(); }

ObjectDiff::NewRevisionsData ObjectDiff::extractCommitData(ObjectDiff diff)
{ return std::move(diff.newRevisionsData_); }

} // namespace groupedit
} // namespace wiki
} // namespace maps
