#pragma once

#include <yandex/maps/wiki/groupedit/common.h>
#include <yandex/maps/wiki/revision/revisionsgateway.h>

#include <list>

namespace maps {
namespace wiki {
namespace groupedit {

class Object;

class ObjectDiff
{
public:
    typedef revision::RevisionsGateway::NewRevisionData NewRevisionData;
    typedef std::list<NewRevisionData> NewRevisionsData;

    explicit ObjectDiff(Object obj);

    ObjectDiff(const ObjectDiff&) = delete;
    ObjectDiff(ObjectDiff&&) = default;

    size_t revisionsCount() const;

    static NewRevisionsData extractCommitData(ObjectDiff diff);

private:
    NewRevisionsData newRevisionsData_;
};

} // namespace groupedit
} // namespace wiki
} // namespace maps
