#pragma once

#include <yandex/maps/wiki/groupedit/common.h>

#include <maps/libs/geolib/include/polygon.h>

#include <functional>
#include <vector>

namespace maps {
namespace wiki {

namespace revision {

class Snapshot;
class RevisionID;

namespace filters {

class ProxyFilterExpr;

} // namespace filters
} // namespace revision

namespace groupedit {

class GeometryFilter;
class Object;
typedef std::function<void(std::vector<Object>)> BatchCallback;

// Loads objects from database in batches, calls batchCallback
// for each of them once.

void loadObjects(
    const revision::Snapshot& snapshot,
    const std::vector<revision::RevisionID>& revisionIds,
    const GeometryFilter& geomFilter,
    BatchCallback batchCallback);

} // namespace groupedit
} // namespace wiki
} // namespace maps
