#include "relation_data.h"

#include <yandex/maps/wiki/groupedit/relation.h>
#include <yandex/maps/wiki/revision/objectrevision.h>

#include <maps/libs/common/include/exception.h>

namespace maps {
namespace wiki {
namespace groupedit {

Relation::Relation(
        TObjectId boundObjectId,
        std::shared_ptr<RelationData> relationDataPtr)
    : boundObjectId_(boundObjectId)
    , relationDataPtr_(std::move(relationDataPtr))
{
    REQUIRE(relationDataPtr_, "Invalid relation data pointer");

    if (relationDataPtr_->masterId == boundObjectId) {
        type_ = Relation::Type::Slave;
    } else {
        REQUIRE(relationDataPtr_->slaveId == boundObjectId,
            "Unrelated relation");
        type_ = Relation::Type::Master;
    }
}

const std::string& Relation::role() const
{ return relationDataPtr_->role; }

TObjectId Relation::otherId() const
{
    switch (type_) {
        case Relation::Type::Master:
            return relationDataPtr_->masterId;
        case Relation::Type::Slave:
            return relationDataPtr_->slaveId;
    }
}

const TCategoryId& Relation::otherCategory() const
{
    switch (type_) {
        case Relation::Type::Master:
            return relationDataPtr_->masterCategory;
        case Relation::Type::Slave:
            return relationDataPtr_->slaveCategory;
    }
}

bool Relation::isDeleted() const
{
    return relationDataPtr_->deletedFrom != 0;
}

void Relation::setDeleted()
{
    TObjectId expected = 0;
    relationDataPtr_->deletedFrom.compare_exchange_strong(
        expected, boundObjectId_);
}

} // namespace groupedit
} // namespace wiki
} // namespace maps
