#pragma once
//#include "magic_strings.h"

#include <yandex/maps/wiki/groupedit/common.h>
#include <yandex/maps/wiki/revision/revisionid.h>
#include <yandex/maps/wiki/revision/objectrevision.h>

#include <maps/libs/common/include/exception.h>

#include <atomic>

namespace maps {
namespace wiki {
namespace groupedit {

const std::string REL_ROLE_ATTR = "rel:role";
const std::string REL_SLAVE_ATTR = "rel:slave";
const std::string REL_MASTER_ATTR = "rel:master";

struct RelationData
{
    explicit RelationData(const revision::ObjectRevision& revision)
        : revisionId(revision.id())
        , deletedFrom(0)
    {
        REQUIRE(revision.type() == revision::RevisionType::Relation,
            "Incorrect revision type");
        REQUIRE(revision.data().relationData, "Relation has no link info");
        REQUIRE(revision.data().attributes, "Relation has no attributes");
        REQUIRE(!revision.data().deleted, "Loaded deleted relation");

        role = revision.data().attributes->at(REL_ROLE_ATTR);

        masterId = revision.data().relationData->masterObjectId();
        masterCategory = revision.data().attributes->at(REL_MASTER_ATTR);

        slaveId = revision.data().relationData->slaveObjectId();
        slaveCategory = revision.data().attributes->at(REL_SLAVE_ATTR);
    }

    RelationData(
            std::string role_,
            TObjectId masterId_,
            TCategoryId masterCategory_,
            TObjectId slaveId_,
            TCategoryId slaveCategory_)
        : role(std::move(role_))
        , masterId(masterId_)
        , masterCategory(std::move(masterCategory_))
        , slaveId(slaveId_)
        , slaveCategory(std::move(slaveCategory_))
        , deletedFrom(0)
    { }

    revision::RevisionID revisionId;
    std::string role;

    TObjectId masterId;
    TCategoryId masterCategory;

    TObjectId slaveId;
    TCategoryId slaveCategory;

    std::atomic<TObjectId> deletedFrom;
};

} // namespace groupedit
} // namespace wiki
} // namespace maps
