#include <yandex/maps/wiki/http/blackbox/blackbox.h>
#define BOOST_TEST_MAIN
#include <boost/test/unit_test.hpp>

namespace maps {
namespace wiki {

BOOST_AUTO_TEST_CASE(gateway)
{
    const std::string REAL_USER_EMAIL = "vlkulpinov@yandex.com";
    const blackbox::UID REAL_USER_UID = 255374041;
    const blackbox::UID UNREAL_USER_UID = 0;

    maps::common::RetryPolicy retryPolicy;
    blackbox::Configuration config("blackbox-mimino.yandex.net");

    blackbox::Gateway blackbox(config, retryPolicy);
    BOOST_CHECK_EQUAL(blackbox.isEmailValid(REAL_USER_EMAIL, REAL_USER_UID), true);
    BOOST_CHECK_EQUAL(blackbox.isEmailValid(REAL_USER_EMAIL, UNREAL_USER_UID), false);

    BOOST_CHECK(!blackbox.defaultUserInfo(UNREAL_USER_UID));

    auto userInfo = blackbox.defaultUserInfo(REAL_USER_UID);
    BOOST_REQUIRE(userInfo);
    BOOST_CHECK_EQUAL(userInfo->email(), REAL_USER_EMAIL);
    BOOST_CHECK_EQUAL(*userInfo->username(), "Вася Пупкин");
    BOOST_CHECK_EQUAL(userInfo->uid(), REAL_USER_UID);
}

} //namespace wiki
} //namespace maps
