#include <yandex/maps/wiki/http/fbapi/gateway.h>
#define BOOST_TEST_MAIN
#include <boost/test/unit_test.hpp>

#include <iostream>

namespace maps::wiki::fbapi {

namespace {

static const std::string BASE_URL = "http://feedback-int.tst.c.maps.yandex.net";

Gateway createGateway()
{
    Configuration configuration(BASE_URL);
    maps::common::RetryPolicy retryPolicy;
    return Gateway(configuration, retryPolicy);
}

} // namespace


BOOST_AUTO_TEST_CASE(get_task)
{
    auto gateway = createGateway();
    auto task = gateway.taskById("0c7769ac-d806-08da-c3f1-1121415c84c0");
}

BOOST_AUTO_TEST_CASE(get_tasks)
{
    auto gateway = createGateway();
    TasksFilter filter(Service::Nmaps, TaskStatus::New);
    PageParams pageParams;
    pageParams.setOffset(1);
    auto tasks = gateway.tasksByFilter(filter, pageParams);
}

BOOST_AUTO_TEST_CASE(change_task)
{
    auto gateway = createGateway();
    ChangeTaskParams params;
    params.setNewService(Service::Support);
    params.setNewStatus(TaskStatus::New);
    params.setMessage("vot eto povorot");
    gateway.changeTaskById("239c2db0-e98a-7036-3e2b-6e2d2fc68fab", params);
}

BOOST_AUTO_TEST_CASE(visit_task)
{
    auto gateway = createGateway();
    TasksFilter filter(Service::Nmaps, TaskStatus::New);
    visitTasks(gateway, filter, WithHistory::No,
        [](const Task& task){
            std::cout << "visited task with id " << task.id() << std::endl;
            return true;
        }
    );
}

} // namespace maps::wiki::fbapi
