#include <yandex/maps/wiki/http/fbapi/method_params.h>

namespace maps::wiki::fbapi {

ChangeTaskParams& ChangeTaskParams::update(ChangeTaskParams other)
{
    if (other.newService_)      this->newService_       = std::move(other.newService_);
    if (other.serviceObjectId_) this->serviceObjectId_  = std::move(other.serviceObjectId_);
    if (other.newStatus_)       this->newStatus_        = std::move(other.newStatus_);
    if (other.requestTemplateId_) this->requestTemplateId_ = std::move(other.requestTemplateId_);
    if (other.resolution_)      this->resolution_       = std::move(other.resolution_);
    if (other.actorService_)    this->actorService_     = std::move(other.actorService_);
    if (other.message_)         this->message_          = std::move(other.message_);

    return *this;
}

void ChangeTaskParams::json(maps::json::ObjectBuilder builder) const {
    builder["task"] << [&](json::ObjectBuilder builder) {
        if (newService_) {
            builder["service"] << toString(*newService_);
        }
        if (serviceObjectId_) {
            builder["service_object_id"] << *serviceObjectId_;
        }
        if (newStatus_) {
            builder["status"] << toString(*newStatus_);
        }
        if (requestTemplateId_) {
            builder["request_template_id"] << *requestTemplateId_;
        }
        if (resolution_) {
            builder["resolution"] << toString(*resolution_);
        }
    };

    if (actorService_) {
        builder["service"] << toString(*actorService_);
    }
    if (message_) {
        builder["message"] << *message_;
    }
}

} // namespace maps::wiki::fbapi
