#include <yandex/maps/wiki/http/fbapi/models/common.h>
#include <maps/libs/enum_io/include/enum_io.h>

namespace maps::wiki::fbapi {

namespace {

constexpr enum_io::Representations<Service>
SERVICE_STRINGS {
    {Service::Nmaps, "nmaps"},
    {Service::Sprav, "sprav"},
    {Service::Support, "support"}
};

constexpr enum_io::Representations<TaskStatus>
TASK_STATUS_STRINGS {
    {TaskStatus::New, "new"},
    {TaskStatus::InProgress, "in_progress"},
    {TaskStatus::NeedInfo, "need_info"},
    {TaskStatus::Accepted, "accepted"},
    {TaskStatus::Rejected, "rejected"},
    {TaskStatus::Published, "published"}
};

constexpr enum_io::Representations<TaskResolution>
    TASK_RESOLUTION_STRINGS {
    {TaskResolution::AutoCleanWeb, "auto-clean-web"},
    {TaskResolution::IncorrectData, "incorrect-data"},
    {TaskResolution::NoData, "no-data"},
    {TaskResolution::NoInfo, "no-info"},
    {TaskResolution::ProhibitedByRules, "prohibited-by-rules"},
    {TaskResolution::RedirectToContentAuto, "redirect-to-content-auto"},
    {TaskResolution::RedirectToContentBicycle, "redirect-to-content-bicycle"},
    {TaskResolution::RedirectToContentBigTask, "redirect-to-content-big-task"},
    {TaskResolution::RedirectToContentMasstransit, "redirect-to-content-masstransit"},
    {TaskResolution::RedirectToContentOther, "redirect-to-content-other"},
    {TaskResolution::RedirectToContentPedestrian, "redirect-to-content-pedestrian"},
    {TaskResolution::RedirectToContentRoadEvents, "redirect-to-content-road-events"},
    {TaskResolution::RedirectToContentToponym, "redirect-to-content-toponym"},
    {TaskResolution::RedirectToContentTruck, "redirect-to-content-truck"},
    {TaskResolution::RedirectToPlatformAuto, "redirect-to-platform-auto"},
    {TaskResolution::RedirectToPlatformBicycle, "redirect-to-platform-bicycle"},
    {TaskResolution::RedirectToPlatformMasstransit, "redirect-to-platform-masstransit"},
    {TaskResolution::RedirectToPlatformToponym, "redirect-to-platform-toponym"},
    {TaskResolution::RedirectToPlatformTruck, "redirect-to-platform-truck"},
    {TaskResolution::RedirectToSprav, "redirect-to-sprav"},
    {TaskResolution::RedirectToSupport, "redirect-to-support"},
    {TaskResolution::Spam, "spam"},
};

constexpr enum_io::Representations<WithHistory>
WITH_HISTORY_STRINGS {
    {WithHistory::Yes, "yes"},
    {WithHistory::No, "no"},
};

constexpr enum_io::Representations<TravelMode>
TRAVEL_MODE_STRINGS {
    {TravelMode::Auto, "auto"},
    {TravelMode::Masstransit, "masstransit"},
    {TravelMode::Pedestrian, "pedestrian"},
    {TravelMode::Bicycle, "bicycle"},
    {TravelMode::Scooter, "scooter"},
    {TravelMode::Taxi, "taxi"},
    {TravelMode::Truck, "truck"}
};

constexpr enum_io::Representations<RouteErrorType>
ROUTE_ERROR_TYPE_STRINGS {
    {RouteErrorType::LeftTurnProhibited, "left_turn_prohibited"},
    {RouteErrorType::RightTurnProhibited, "right_turn_prohibited"},
    {RouteErrorType::UTurnProhibited, "u_turn_prohibited"},
    {RouteErrorType::Barrier, "barrier"},
    {RouteErrorType::ProhibitingSign, "prohibiting_sign"},
    {RouteErrorType::Obstruction, "obstruction"},
    {RouteErrorType::PoorCondition, "poor_condition"},
    {RouteErrorType::NoRoad, "no_road"},
    {RouteErrorType::Other, "other"}
};

} // unnamed namespace

DEFINE_ENUM_IO(Service, SERVICE_STRINGS);

DEFINE_ENUM_IO(TaskStatus, TASK_STATUS_STRINGS);

DEFINE_ENUM_IO(TaskResolution, TASK_RESOLUTION_STRINGS);

DEFINE_ENUM_IO(WithHistory, WITH_HISTORY_STRINGS);

DEFINE_ENUM_IO(TravelMode, TRAVEL_MODE_STRINGS);

DEFINE_ENUM_IO(RouteErrorType, ROUTE_ERROR_TYPE_STRINGS);

} // namespace maps::wiki::fbapi
