#include <yandex/maps/wiki/http/fbapi/models/context.h>

namespace maps::wiki::fbapi {

namespace {

namespace key {

const std::string ENTRANCE = "entrance";
const std::string FENCE = "fence";
const std::string OTHER = "other";
const std::string PARKING = "parking";
const std::string ROAD = "road";
const std::string ROUTE = "route";
const std::string STOP = "stop";
const std::string TOPONYM = "toponym";

} // namespace key

} // unnamed namespase

// QuestionContext

template<>
Entrance QuestionContext::as() const
{
    return Entrance(data_[key::ENTRANCE]);
}

template<>
RouteQuestionContext QuestionContext::as() const
{
    return RouteQuestionContext(data_[key::ROUTE]);
}

template<>
std::optional<Stop> QuestionContext::as() const
{
    if (data_.hasField(key::STOP)) {
        return Stop(data_[key::STOP]);
    }
    return std::nullopt;
}

template<>
Toponym QuestionContext::as() const
{
    return Toponym(data_[key::TOPONYM]);
}

// AnswerContext

template<>
Entrance AnswerContext::as() const
{
    return Entrance(data_[key::ENTRANCE]);
}

template<>
Fence AnswerContext::as() const
{
    return Fence(data_[key::FENCE]);
}

template<>
OtherContext AnswerContext::as() const
{
    return OtherContext(data_[key::OTHER]);
}

template<>
std::optional<Parking> AnswerContext::as() const
{
    if (data_.hasField(key::PARKING)) {
        return Parking(data_[key::PARKING]);
    }
    return std::nullopt;
}

template<>
std::optional<Road> AnswerContext::as() const {
    if (data_.hasField(key::ROAD)) {
        return Road(data_[key::ROAD]);
    }
    return std::nullopt;
}

template<>
RouteAnswerContext AnswerContext::as() const
{
    return RouteAnswerContext(data_[key::ROUTE]);
}

template<>
std::optional<Stop> AnswerContext::as() const
{
    if (data_.hasField(key::STOP)) {
        return Stop(data_[key::STOP]);
    }
    return std::nullopt;
}

template<>
Toponym AnswerContext::as() const
{
    return Toponym(data_[key::TOPONYM]);
}

} // namespace maps::wiki::fbapi
