#include <yandex/maps/wiki/http/fbapi/models/entrance.h>

#include "parsing.h"

namespace maps::wiki::fbapi {

Entrance::Entrance(json::Value data)
    : data_(std::move(data))
{}

std::optional<std::string>
Entrance::name() const
{
    return parseOptField<std::string>(data_, "name");
}

std::optional<geolib3::Point2>
Entrance::center() const
{
    return parseOptField<geolib3::Point2>(data_, "center_point");
}

} // namespace maps::wiki::fbapi
