#include <yandex/maps/wiki/http/fbapi/models/fence.h>

#include "parsing.h"

namespace maps::wiki::fbapi {

/// Gate

Gate::Gate(json::Value data)
    : data_(std::move(data))
{}

geolib3::Point2 Gate::center() const
{
    return parseField<geolib3::Point2>(data_, "center_point");
}


/// Fence

Fence::Fence(json::Value data)
    : data_(std::move(data))
{}

std::optional<geolib3::Point2> Fence::center() const
{
    return parseOptField<geolib3::Point2>(data_, "center_point");
}

geolib3::PointsVector Fence::points() const
{
    return parseField<geolib3::PointsVector>(data_, "points");
}

Gates Fence::gates() const
{
    return parseField<Gates>(data_, "gates");
}

} // namespace maps::wiki::fbapi
