#include <yandex/maps/wiki/http/fbapi/models/original_task.h>

#include "parsing.h"

namespace maps::wiki::fbapi {

FormContext::FormContext(json::Value data)
    : data_(std::move(data))
{}

std::optional<std::string>
FormContext::searchText() const
{
    return parseOptField<std::string>(data_, "search_text");
}

bool FormContext::fromPush() const
{
    static const std::string PUSH_SUBSTRING = "push_notifications";
    auto clientContext = parseOptField<std::string>(data_, "client_context_id");
    return clientContext && clientContext->find(PUSH_SUBSTRING) != std::string::npos;
}


OriginalTaskMetadata::OriginalTaskMetadata(json::Value data)
    : data_(std::move(data))
{}

std::string
OriginalTaskMetadata::clientId() const
{
    return parseField<std::string>(data_, "client_id");
}

std::string
OriginalTaskMetadata::version() const
{
    return parseField<std::string>(data_, "version");
}

std::optional<Version>
OriginalTaskMetadata::applicationVersion() const
{
    return parseOptField<Version>(data_, "application_version");
}

std::optional<std::string>
OriginalTaskMetadata::uuid() const
{
    return parseOptField<std::string>(data_, "uuid");
}

std::optional<std::string>
OriginalTaskMetadata::deviceId() const
{
    return parseOptField<std::string>(data_, "device_id");
}

std::optional<std::string>
OriginalTaskMetadata::sessionId() const
{
    return parseOptField<std::string>(data_, "session_id");
}

std::optional<uint64_t>
OriginalTaskMetadata::uid() const
{
    return parseOptField<uint64_t>(data_, "uid");
}

std::optional<std::string>
OriginalTaskMetadata::yandexuid() const
{
    return parseOptField<std::string>(data_, "yandexuid");
}

std::optional<std::string>
OriginalTaskMetadata::ip() const
{
    return parseOptField<std::string>(data_, "ip");
}

std::optional<std::string>
OriginalTaskMetadata::fingerprint() const
{
    return parseOptField<std::string>(data_, "fingerprint");
}

std::optional<std::string>
OriginalTaskMetadata::userAgent() const
{
    return parseOptField<std::string>(data_, "user_agent");
}

std::string
OriginalTaskMetadata::locale() const
{
    return parseField<std::string>(data_, "locale");
}


OriginalTask::OriginalTask(json::Value data)
    : data_(std::move(data))
{}

std::string
OriginalTask::formId() const
{
    return parseField<std::string>(data_, "form_id");
}

std::string
OriginalTask::questionId() const
{
    return parseField<std::string>(data_, "question_id");
}

std::string
OriginalTask::answerId() const
{
    return parseField<std::string>(data_, "answer_id");
}

std::optional<std::string>
OriginalTask::objectId() const
{
    return parseOptField<std::string>(data_, "object_id");
}

std::optional<std::string>
OriginalTask::objectUri() const
{
    return parseOptField<std::string>(data_, "object_uri");
}

std::optional<std::string>
OriginalTask::userEmail() const
{
    return parseOptField<std::string>(data_, "user_email");
}

std::optional<std::string>
OriginalTask::objectUrl() const
{
    return parseOptField<std::string>(data_, "object_url");
}

std::optional<QuestionContext>
OriginalTask::questionContext() const
{
    return parseOptField<QuestionContext>(data_, "question_context");
}

std::optional<AnswerContext>
OriginalTask::answerContext() const
{
    return parseOptField<AnswerContext>(data_, "answer_context");
}

std::optional<std::string>
OriginalTask::message() const
{
    return parseOptField<std::string>(data_, "message");
}

std::optional<std::string>
OriginalTask::supportMessage() const
{
    return parseOptField<std::string>(data_, "support_message");
}

geolib3::Point2
OriginalTask::formPoint() const
{
    return parseField<geolib3::Point2>(data_, "form_point");
}

OriginalTaskMetadata
OriginalTask::metadata() const
{
    return parseField<OriginalTaskMetadata>(data_, "metadata");
}

std::optional<FormContext>
OriginalTask::formContext() const
{
    return parseOptField<FormContext>(data_, "form_context");
}

} // namespace maps::wiki::fbapi
