#include <yandex/maps/wiki/http/fbapi/models/parking.h>

#include "parsing.h"

namespace maps::wiki::fbapi {

Parking::Parking(json::Value data)
    : data_(std::move(data))
{}

std::optional<geolib3::Point2>
Parking::center() const
{
    return parseOptField<geolib3::Point2>(data_, "center_point");
}

geolib3::PointsVector Parking::entrances() const
{
    return parseField<geolib3::PointsVector>(data_, "entrance_points");
}

} // namespace maps::wiki::fbapi
