#include "parsing.h"

#include <maps/libs/json/include/value.h>

namespace maps::wiki::fbapi {

std::string
toShortString(const json::Value& value)
{
    size_t maxSize = 100;
    auto fullStr = (json::Builder() << value).str();
    if (fullStr.size() <= maxSize) {
        return fullStr;
    }
    return fullStr.substr(0, maxSize) + " ...";
}

} // namespace maps::wiki::fbapi
