#include <yandex/maps/wiki/http/fbapi/models/road.h>

#include "parsing.h"

namespace maps::wiki::fbapi {

Road::Road(json::Value data)
    : data_(std::move(data))
{}

std::optional<std::string>
Road::name() const
{
    return parseOptField<std::string>(data_, "name");
}

geolib3::Point2 Road::center() const
{
    return parseField<geolib3::Point2>(data_, "center_point");
}

geolib3::PointsVector Road::points() const
{
    return parseField<geolib3::PointsVector>(data_, "points");
}

} // namespace maps::wiki::fbapi
