#include <yandex/maps/wiki/http/fbapi/models/route_answer_context.h>

#include "parsing.h"

namespace maps::wiki::fbapi {

///
/// RouteErrorProhibitingSignContext
///

RouteErrorProhibitingSignContext::RouteErrorProhibitingSignContext(json::Value data)
    : data_(std::move(data))
{}

std::optional<VehicleRestrictions>
RouteErrorProhibitingSignContext::vehicleRestrictions() const
{
    return parseOptField<VehicleRestrictions>(data_, "vehicle_restrictions");
}


///
/// RouteError
///

RouteError::RouteError(json::Value data)
    : data_(std::move(data))
{}

geolib3::Point2 RouteError::point() const
{
    return parseField<geolib3::Point2>(data_, "point");
}

RouteErrorType RouteError::type() const
{
    return parseField<RouteErrorType>(data_, "type");
}

std::optional<RouteErrorProhibitingSignContext> RouteError::prohibitingSignContext() const
{
    PARSING_REQUIRE(
        type() == RouteErrorType::ProhibitingSign,
        "RouteErrorProhibitingSignContext not available for type '" << type() << "'"
    );
    return parseOptField<RouteErrorProhibitingSignContext>(data_, "context");
}

///
/// RouteAnswerSegment
///

RouteAnswerSegment::RouteAnswerSegment(json::Value data)
    : data_(std::move(data))
{}

TravelMode RouteAnswerSegment::travelMode() const
{
    return parseField<TravelMode>(data_, "travel_mode");
}

geolib3::PointsVector RouteAnswerSegment::points() const
{
    return parseField<geolib3::PointsVector>(data_, "points");
}


///
/// RouteAnswerContext
///

RouteAnswerContext::RouteAnswerContext(json::Value data)
    : data_(std::move(data))
{}

RouteErrors RouteAnswerContext::errors() const
{
    return parseField<RouteErrors>(data_, "errors");
}

RouteAnswerSegments RouteAnswerContext::segments() const
{
    return parseField<RouteAnswerSegments>(data_, "segments");
}

} // namespace maps::wiki::fbapi
