#include <yandex/maps/wiki/http/fbapi/models/route_question_context.h>

#include "parsing.h"

namespace maps::wiki::fbapi {

///
/// RouteQuestionSegment
///

RouteQuestionSegment::RouteQuestionSegment(json::Value data)
    : data_(std::move(data))
{}

TravelMode RouteQuestionSegment::travelMode() const
{
    return parseField<TravelMode>(data_, "travel_mode");
}

geolib3::Point2 RouteQuestionSegment::from() const
{
    return parseField<geolib3::Point2>(data_, "from");
}

geolib3::Point2 RouteQuestionSegment::to() const
{
    return parseField<geolib3::Point2>(data_, "to");
}


///
/// RouteQuestionContext
///

RouteQuestionContext::RouteQuestionContext(json::Value data)
    : data_(std::move(data))
{}

TravelMode RouteQuestionContext::travelMode() const
{
    return parseField<TravelMode>(data_, "travel_mode");
}

bool RouteQuestionContext::trafficJams() const
{
    return parseField<bool>(data_, "traffic_jams");
}

geolib3::PointsVector RouteQuestionContext::wayPoints() const
{
    return parseField<geolib3::PointsVector>(data_, "way_points");
}

geolib3::PointsVector RouteQuestionContext::viaPoints() const
{
    return parseField<geolib3::PointsVector>(data_, "via_points");
}

std::optional<std::string> RouteQuestionContext::encodedPoints() const
{
    return parseOptField<std::string>(data_, "encoded_points");
}

RouteQuestionSegments RouteQuestionContext::segments() const
{
    return parseField<RouteQuestionSegments>(data_, "segments");
}

std::optional<std::string> RouteQuestionContext::uri() const
{
    return parseOptField<std::string>(data_, "uri");
}

std::optional<chrono::TimePoint> RouteQuestionContext::departureAt() const
{
    return parseOptField<chrono::TimePoint>(data_, "departure");
}

std::optional<VehicleRestrictions> RouteQuestionContext::vehicleRestrictions() const
{
    return parseOptField<VehicleRestrictions>(data_, "vehicle_restrictions");
}

} // namespace maps::wiki::fbapi
