#include <yandex/maps/wiki/http/fbapi/models/stop.h>

#include "parsing.h"

namespace maps::wiki::fbapi {

Stop::Stop(json::Value data)
    : data_(std::move(data))
{}

std::optional<std::string> Stop::uri() const
{
    return parseOptField<std::string>(data_, "uri");
}

std::optional<std::string>
Stop::name() const
{
    return parseOptField<std::string>(data_, "name");
}

geolib3::Point2 Stop::center() const
{
    return parseField<geolib3::Point2>(data_, "center_point");
}

} // namespace maps::wiki::fbapi
